﻿using System;
using Microsoft.SharePoint.Client;

namespace CreateWeb
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         WebCollection webs = ctx.Web.Webs;

         // Definition der Eigenschaften des Webs
         Web newWeb = webs.Add(new WebCreationInformation()
         {
            Title = "Mein Blog",
            Url = "MeinBlog",
            UseSamePermissionsAsParentSite = true,
            Language = 1033,
            WebTemplate = "BLOG#0",
         });

         // Definition der zu ladenen Eigenschaften des neuen Webs
         ctx.Load(newWeb,
             w => w.ServerRelativeUrl,
             w => w.Created);

         // Paket zum Server senden
         ctx.ExecuteQuery();

         Console.WriteLine("Neue Website erfolgreich erstellt: {0} ({1})",
            newWeb.ServerRelativeUrl,
            newWeb.Created);
      }
   }
}